/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.fabric.platform.configuration;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Function;
import java.util.function.Supplier;
import mod.chiselsandbits.fabric.platform.configuration.FabricConfigurationSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FabricConfigurationValue<T>
implements Supplier<T> {
    private final Logger LOGGER = LogManager.getLogger();
    protected final FabricConfigurationSource source;
    protected final String key;
    protected final Function<JsonElement, T> reader;
    protected final Function<T, JsonElement> writer;
    protected T value = null;
    protected final T defaultValue;

    public FabricConfigurationValue(FabricConfigurationSource source, String key, Function<JsonElement, T> reader, Function<T, JsonElement> writer, T defaultValue) {
        this.source = source;
        this.key = key;
        this.reader = reader;
        this.writer = writer;
        this.defaultValue = defaultValue;
    }

    @Override
    public T get() {
        if (this.value != null) {
            return this.value;
        }
        try {
            JsonElement valueElement = this.resolve();
            T value = this.reader.apply(valueElement);
            this.value = this.verify(value);
            return value;
        }
        catch (KeyResolveException e) {
            this.LOGGER.error(e.getMessage());
            this.value = this.defaultValue;
            return this.value;
        }
        catch (Exception e) {
            this.LOGGER.error("General failure during configuration parsing", (Throwable)e);
            this.value = this.defaultValue;
            return this.value;
        }
    }

    public void write() {
        JsonObject sourceObject;
        JsonObject parentKey;
        if (this.value == null) {
            this.value = this.defaultValue;
        }
        if ((parentKey = FabricConfigurationValue.resolveFirstParent(this.key, sourceObject = this.source.getConfig(), true)) == null) {
            throw new KeyResolveException(this.key, this.source.getName());
        }
        String valueKey = FabricConfigurationValue.getValueKey(this.key);
        if (parentKey.has(valueKey)) {
            parentKey.remove(valueKey);
        }
        parentKey.add(valueKey, this.writer.apply(this.value));
    }

    public void write(T value) {
        this.value = value;
        this.write();
    }

    protected T verify(T value) {
        return value;
    }

    public void resetCache() {
        this.value = null;
    }

    private JsonElement resolve() {
        JsonObject sourceObject = this.source.getConfig();
        JsonObject parentKey = FabricConfigurationValue.resolveFirstParent(this.key, sourceObject, false);
        if (parentKey == null) {
            throw new KeyResolveException(this.key, this.source.getName());
        }
        String valueKey = FabricConfigurationValue.getValueKey(this.key);
        JsonElement element = parentKey.get(valueKey);
        if (element == null) {
            throw new KeyResolveException(this.key, this.source.getName());
        }
        return element;
    }

    private static JsonObject resolveFirstParent(String key, JsonObject source, boolean createIfMissing) {
        String[] parts = key.split("\\.");
        JsonObject current = source;
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            JsonElement element = current.get(part);
            if (element == null) {
                if (!createIfMissing) {
                    return null;
                }
                current.add(part, (JsonElement)new JsonObject());
                element = current.getAsJsonObject(part);
            }
            if (i == parts.length - 1) {
                return current;
            }
            if (!element.isJsonObject()) {
                return null;
            }
            current = element.getAsJsonObject();
        }
        return null;
    }

    private static String getValueKey(String key) {
        String[] parts = key.split("\\.");
        return parts[parts.length - 1];
    }

    private static final class KeyResolveException
    extends IllegalStateException {
        public KeyResolveException(String key, String configurationName) {
            super("Could not resolve configuration key: " + key + " in: " + configurationName);
        }
    }
}

